<?php
require_once 'config.php';

if (!isset($_GET['id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'User ID not provided']);
    exit;
}

$user_id = intval($_GET['id']);

$conn = getSecureConnection();

$stmt = $conn->prepare("SELECT id, username, email, role, is_active FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['error' => 'User not found']);
    exit;
}

$user = $result->fetch_assoc();
$stmt->close();
$conn->close();

echo json_encode($user);
?>
